/*
 * Copyright (C) 2012-2025 Japan Smartphone Security Association
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jssec.notification.visibilityPrivate;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.RemoteInput;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;

import static org.jssec.notification.visibilityPrivate.VisibilityPrivateNotificationActivity.DEFAULT_CHANNEL;

public class NotificationReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        if (Build.VERSION.SDK_INT >= 28) {
            Bundle remoteInput = RemoteInput.getResultsFromIntent(intent);
            String replytext = "received : ";
            if (remoteInput != null) {
                CharSequence message =
                        remoteInput.getCharSequence(VisibilityPrivateNotificationActivity.REMOTE_REPLY);
                replytext += message.toString();
            }
            repliedNotification(context, replytext);
        }
    }

    private void repliedNotification(Context context, String replytext) {
        if (Build.VERSION.SDK_INT >= 28) {
            Notification repliedNotification =
                    new Notification.Builder(context, DEFAULT_CHANNEL)
                            .setSmallIcon(R.drawable.ic_launcher)
                            .setContentText(replytext)
                            .build();

            NotificationManager notificationManager =
                    (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
            notificationManager.notify(0, repliedNotification);
        }
    }
}
